/*
 * Decompiled with CFR 0.152.
 */
package tk.ufonet.kurzy.gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ProgressMonitor;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import tk.ufonet.kurzy.core.Tabulka;
import tk.ufonet.kurzy.gui.NastaveniaDialog;
import tk.ufonet.kurzy.gui.OProgrameDialog;
import tk.ufonet.kurzy.subory.KonfiguracnySubor;
import tk.ufonet.kurzy.subory.Stahovac;

public class KurzyGUI
extends JFrame {
    private String aVerzia;
    private String aNazovSuboru;
    private String aAdresaURL;
    private Tabulka aTabulka;
    private KonfiguracnySubor aKonfiguracnySubor = KonfiguracnySubor.dajInstanciu();
    private JLabel jChyba;
    private JLabel jDatumLabel;
    private JTextField jDatumListka;
    private JLabel jDatumListkaLabel;
    private JDialog jDialog1;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator3;
    private JTable jTabulka;
    private JMenuItem mAbout;
    private JMenuItem mDownload;
    private JMenuItem mExit;
    private JMenu mFILE;
    private JMenu mHELPER;
    private JMenuItem mSettings;
    private JSpinner sDatum;

    public KurzyGUI() {
        this.zmenVzhlad();
        this.setLocationRelativeTo(null);
        this.initComponents();
        this.aVerzia = "v2.0";
        this.aNazovSuboru = "eurofxref.xml";
        this.aAdresaURL = "http://www.ecb.europa.eu/stats/eurofxref/eurofxref-hist.xml";
        this.setTitle("Kurzy " + this.aVerzia);
        this.jChyba.setVisible(false);
        this.aTabulka = new Tabulka(this.aKonfiguracnySubor, this.jTabulka, this.sDatum, this.jChyba, this.jDatumListka, this.aNazovSuboru);
        this.aTabulka.nacitajListok();
        this.aTabulka.obnovTabulku();
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.jScrollPane1 = new JScrollPane();
        this.jTabulka = new JTable();
        this.sDatum = new JSpinner();
        this.jDatumListka = new JTextField();
        this.jDatumListkaLabel = new JLabel();
        this.jDatumLabel = new JLabel();
        this.jChyba = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.mFILE = new JMenu();
        this.mDownload = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.mSettings = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.mExit = new JMenuItem();
        this.mHELPER = new JMenu();
        this.mAbout = new JMenuItem();
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        jDialog1Layout.setVerticalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.setDefaultCloseOperation(3);
        this.setTitle(this.aVerzia);
        this.jTabulka.setModel(new DefaultTableModel(new Object[0][], new String[]{"Mena", "V\u00fdmenn\u00fd kurz"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTabulka.setColumnSelectionAllowed(true);
        this.jTabulka.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.jTabulka);
        this.jTabulka.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.sDatum.setModel(new SpinnerDateModel());
        this.sDatum.setEditor(new JSpinner.DateEditor(this.sDatum, "dd.MM.yyyy"));
        this.sDatum.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                KurzyGUI.this.sDatumStateChanged(evt);
            }
        });
        this.jDatumListkaLabel.setText("D\u00e1tum kurzov\u00e9ho l\u00edstka:");
        this.jDatumLabel.setText("D\u00e1tum kurzu:");
        this.jChyba.setFont(new Font("Tahoma", 1, 14));
        this.jChyba.setForeground(new Color(255, 0, 0));
        this.jChyba.setHorizontalAlignment(0);
        this.jChyba.setText("Chyba");
        this.jChyba.setOpaque(true);
        this.mFILE.setText("S\u00fabor");
        this.mDownload.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.mDownload.setText("Stiahnu\u0165 z internetu");
        this.mDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KurzyGUI.this.mDownloadActionPerformed(evt);
            }
        });
        this.mFILE.add(this.mDownload);
        this.mFILE.add(this.jSeparator1);
        this.mSettings.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mSettings.setText("Nastavenia");
        this.mSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KurzyGUI.this.mSettingsActionPerformed(evt);
            }
        });
        this.mFILE.add(this.mSettings);
        this.mFILE.add(this.jSeparator3);
        this.mExit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.mExit.setText("Ukon\u010di\u0165");
        this.mExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KurzyGUI.this.mExitActionPerformed(evt);
            }
        });
        this.mFILE.add(this.mExit);
        this.jMenuBar1.add(this.mFILE);
        this.mHELPER.setText("Pomocn\u00edk");
        this.mAbout.setText("O programe");
        this.mAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KurzyGUI.this.mAboutActionPerformed(evt);
            }
        });
        this.mHELPER.add(this.mAbout);
        this.jMenuBar1.add(this.mHELPER);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDatumListkaLabel).addComponent(this.jDatumLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sDatum, -2, -1, -2).addComponent(this.jDatumListka, -2, 80, -2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jChyba, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jChyba).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDatumListka, -2, -1, -2).addComponent(this.jDatumListkaLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sDatum, -2, -1, -2).addComponent(this.jDatumLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 148, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void sDatumStateChanged(ChangeEvent evt) {
        this.aTabulka.obnovTabulku();
    }

    private void mAboutActionPerformed(ActionEvent evt) {
        OProgrameDialog oProgrameDialog = new OProgrameDialog((Frame)this, true, this.aVerzia);
        oProgrameDialog.setVisible(true);
    }

    private void mExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void mSettingsActionPerformed(ActionEvent evt) {
        NastaveniaDialog nastaveniaDialog = new NastaveniaDialog((Frame)this, true, this.aTabulka);
        nastaveniaDialog.setVisible(true);
    }

    private void mDownloadActionPerformed(ActionEvent evt) {
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "S\u0165ahovanie kurzov\u00e9ho l\u00edstka...", "...", 0, 100);
        Stahovac stahovac = new Stahovac(progressMonitor, this.aNazovSuboru, this.aTabulka, this.aAdresaURL);
        Thread vlakno = new Thread(stahovac);
        vlakno.start();
    }

    private void zmenVzhlad() {
        String vzhlad = this.aKonfiguracnySubor.dajVzhlad();
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!vzhlad.equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(KurzyGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(KurzyGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(KurzyGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(KurzyGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(KurzyGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(KurzyGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(KurzyGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(KurzyGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new KurzyGUI().setVisible(true);
            }
        });
    }
}

