/*
 * Decompiled with CFR 0.152.
 */
package tk.ufonet.kurzy.subory;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import tk.ufonet.kurzy.core.Tabulka;

public class Stahovac
implements Runnable {
    private String aNazovSuboru;
    private String aAdresa;
    private ProgressMonitor aProgressBar;
    private Component aDialog;
    private Tabulka aTabulka;

    public Stahovac(ProgressMonitor paProgressBar, String paNazovSuboru, Tabulka paTabulka, String paAdresa) {
        this.aProgressBar = paProgressBar;
        this.aNazovSuboru = paNazovSuboru;
        this.aTabulka = paTabulka;
        this.aAdresa = paAdresa;
    }

    @Override
    public void run() {
        this.stiahni();
    }

    public boolean stiahni() {
        try {
            int stiahnuteByty;
            URL url = new URL(this.aAdresa);
            HttpURLConnection spojenie = (HttpURLConnection)url.openConnection();
            if (spojenie.getResponseCode() == 404) {
                JOptionPane.showMessageDialog(this.aDialog, "S\u00fabor sa na serveri nena\u0161iel.", "Chyba", 0);
                return false;
            }
            int velkostSuboru = spojenie.getContentLength();
            File subor = new File(this.aNazovSuboru);
            BufferedInputStream zasobnik = new BufferedInputStream(url.openStream());
            FileOutputStream vystup = new FileOutputStream(subor);
            byte[] data = new byte[1024];
            int hotovo = 0;
            int percento = 0;
            double velkostSuboruMB = (double)velkostSuboru / 1024.0 / 1024.0;
            double velkostSuboruZaokruhlena = (double)Math.round(velkostSuboruMB * 100.0) / 100.0;
            double hotovoMB = 0.0;
            double hotovoZaokruhlena = 0.0;
            while ((stiahnuteByty = zasobnik.read(data, 0, 1024)) != -1) {
                vystup.write(data, 0, stiahnuteByty);
                hotovoMB = (double)(hotovo += stiahnuteByty) / 1024.0 / 1024.0;
                hotovoZaokruhlena = (double)Math.round(hotovoMB * 100.0) / 100.0;
                percento = hotovo * 100 / velkostSuboru;
                this.aProgressBar.setProgress(percento);
                this.aProgressBar.setNote("Stiahnutych " + hotovoZaokruhlena + " MB / " + velkostSuboruZaokruhlena + "MB (" + percento + "%)");
            }
            zasobnik.close();
            vystup.close();
            if (subor.length() == (long)velkostSuboru) {
                this.aTabulka.nacitajListok();
                this.aTabulka.obnovTabulku();
                JOptionPane.showMessageDialog(this.aDialog, "S\u00fabor \u00faspe\u0161ne stiahnut\u00fd.");
                return true;
            }
        }
        catch (SocketException e) {
            JOptionPane.showMessageDialog(this.aDialog, "Ste pripojen\u00fd k internetu ?", "Chyba", 0);
        }
        catch (UnknownHostException e) {
            JOptionPane.showMessageDialog(this.aDialog, "Server sa nena\u0161iel.", "Chyba", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.aDialog, "Chyba.", "Chyba", 0);
        }
        JOptionPane.showMessageDialog(this.aDialog, "S\u0165ahovanie s\u00faboru ne\u00faspe\u0161n\u00e9.", "Chyba", 0);
        return false;
    }
}

