/*
 * Decompiled with CFR 0.152.
 */
package tk.ufonet.rozvrhJava.databaza;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import tk.ufonet.rozvrhJava.databaza.IDatabaza;

public class DatabazaSQLite
implements IDatabaza {
    private String aNazovSuboruDatabazy;
    private Connection aPripojenie;
    private Statement aSQLVyraz;
    private ResultSet aVysledok;
    private ResultSet aAutoincrementID;

    public DatabazaSQLite(String paNazovSuboru) {
        this.aNazovSuboruDatabazy = paNazovSuboru;
        this.aPripojenie = null;
        this.aSQLVyraz = null;
        this.aVysledok = null;
    }

    private boolean pripoj() {
        try {
            Class.forName("org.sqlite.JDBC");
            this.aPripojenie = DriverManager.getConnection("jdbc:sqlite:" + this.aNazovSuboruDatabazy);
            return true;
        }
        catch (ClassNotFoundException | SQLException e) {
            return false;
        }
    }

    @Override
    public ResultSet vykonaj(String paSQLquery) {
        if (this.pripoj()) {
            try {
                this.aSQLVyraz = this.aPripojenie.createStatement();
                this.aSQLVyraz.execute(paSQLquery);
                this.aVysledok = this.aSQLVyraz.getResultSet();
                this.aSQLVyraz = this.aPripojenie.createStatement();
                this.aAutoincrementID = this.aSQLVyraz.executeQuery("SELECT last_insert_rowid()");
                return this.aVysledok;
            }
            catch (SQLException ex) {
                this.odpoj();
                return null;
            }
        }
        return null;
    }

    @Override
    public int dajAutoincrementID() {
        try {
            this.aAutoincrementID.next();
            return this.aAutoincrementID.getInt(1);
        }
        catch (SQLException ex) {
            return 0;
        }
    }

    @Override
    public void odpoj() {
        try {
            if (this.aAutoincrementID != null) {
                this.aAutoincrementID.close();
            }
            if (this.aVysledok != null) {
                this.aVysledok.close();
            }
            if (this.aSQLVyraz != null) {
                this.aSQLVyraz.close();
            }
            if (this.aPripojenie != null) {
                this.aPripojenie.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean existujeTabulka(String paNazov) {
        try {
            String vyraz = "SELECT count(*) as pocet FROM sqlite_master WHERE type='table' AND name='" + paNazov + "'";
            ResultSet vysledok = this.vykonaj(vyraz);
            vysledok.next();
            if (vysledok.getInt("pocet") == 1) {
                this.odpoj();
                return true;
            }
            this.odpoj();
            return false;
        }
        catch (NullPointerException | SQLException ex) {
            return false;
        }
    }
}

