/*
 * Decompiled with CFR 0.152.
 */
package tk.ufonet.rozvrhJava.databaza;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import tk.ufonet.rozvrhJava.databaza.DatabazaSQLite;
import tk.ufonet.rozvrhJava.databaza.IDatabaza;
import tk.ufonet.rozvrhJava.jadro.Hodina;
import tk.ufonet.rozvrhJava.jadro.Rozvrh;

public class SpravcaDatabazy {
    private IDatabaza aDatabaza = new DatabazaSQLite("rozvrh.db");

    public SpravcaDatabazy() {
        this.vytvorTabulky();
    }

    private void vytvorTabulky() {
        String vyraz = "CREATE TABLE IF NOT EXISTS Rozvrh(  id_rozvrh INTEGER NOT NULL        CONSTRAINT Key1 PRIMARY KEY AUTOINCREMENT,  nazov TEXT,  popis TEXT);";
        this.aDatabaza.vykonaj(vyraz);
        this.aDatabaza.odpoj();
        vyraz = "CREATE TABLE IF NOT EXISTS Hodina(  id_hodina INTEGER NOT NULL        CONSTRAINT Key3 PRIMARY KEY AUTOINCREMENT,  id_rozvrh INTEGER NOT NULL,  den INTEGER,  cislo INTEGER,  predmet TEXT,  miestnost TEXT,  ucitel TEXT,  CONSTRAINT ma FOREIGN KEY (id_rozvrh) REFERENCES Rozvrh (id_rozvrh));";
        this.aDatabaza.vykonaj(vyraz);
        this.aDatabaza.odpoj();
    }

    public boolean existujuTabulky() {
        boolean rozvrh = this.aDatabaza.existujeTabulka("Rozvrh");
        boolean hodina = this.aDatabaza.existujeTabulka("Hodina");
        return rozvrh && hodina;
    }

    public int vytvorRozvrh(String paNazov, String paPopis) {
        String vyraz = "INSERT INTO Rozvrh (nazov,popis) VALUES('" + paNazov + "','" + paPopis + "');";
        this.aDatabaza.vykonaj(vyraz);
        int id = this.aDatabaza.dajAutoincrementID();
        this.aDatabaza.odpoj();
        return id;
    }

    public void vytvorHodinu(int paIDRozvrh, Hodina paHodina) {
        int den = paHodina.getDen();
        int cislo = paHodina.getCisloHodiny();
        String predmet = this.osetriPrazdny(paHodina.getPredmet());
        String miestnost = this.osetriPrazdny(paHodina.getMiestnost());
        String ucitel = this.osetriPrazdny(paHodina.getUcitel());
        String vyraz = "INSERT INTO Hodina (id_rozvrh,den,cislo,predmet,miestnost,ucitel) VALUES('" + paIDRozvrh + "','" + den + "','" + cislo + "'," + "'" + predmet + "','" + miestnost + "','" + ucitel + "');";
        this.aDatabaza.vykonaj(vyraz);
        this.aDatabaza.odpoj();
    }

    private int dajIDHodiny(int paIDRozvrh, int paDen, int paCisloHodiny) {
        try {
            String vyraz = "SELECT id_hodina FROM Hodina WHERE id_rozvrh=" + paIDRozvrh + " AND den=" + paDen + " AND cislo=" + paCisloHodiny + ";";
            ResultSet rs = this.aDatabaza.vykonaj(vyraz);
            rs.next();
            int vystup = rs.getInt("id_hodina");
            this.aDatabaza.odpoj();
            return vystup;
        }
        catch (SQLException ex) {
            this.aDatabaza.odpoj();
            return 0;
        }
    }

    public void vymazHodinu(int paIDRozvrh, int paDen, int paCisloHodiny) {
        int id = this.dajIDHodiny(paIDRozvrh, paDen, paCisloHodiny);
        String vyraz = "DELETE FROM Hodina WHERE id_hodina=" + id + ";";
        this.aDatabaza.vykonaj(vyraz);
        this.aDatabaza.odpoj();
    }

    public ArrayList<Rozvrh> nacitajRozvrhy() {
        try {
            ArrayList<Rozvrh> zoznam = new ArrayList<Rozvrh>();
            String vyraz = "SELECT * FROM Rozvrh;";
            ResultSet rs = this.aDatabaza.vykonaj(vyraz);
            while (rs.next()) {
                Rozvrh rozvrh = new Rozvrh(rs.getInt("id_rozvrh"), rs.getString("nazov"), rs.getString("popis"));
                zoznam.add(rozvrh);
            }
            this.aDatabaza.odpoj();
            return zoznam;
        }
        catch (SQLException ex) {
            this.aDatabaza.odpoj();
            return null;
        }
    }

    public Rozvrh nacitajRozvrh(int paIDRozvrhu) {
        try {
            String vyraz = "SELECT * FROM Rozvrh WHERE id_rozvrh=" + paIDRozvrhu + ";";
            ResultSet rs = this.aDatabaza.vykonaj(vyraz);
            rs.next();
            Rozvrh rozvrh = new Rozvrh(rs.getInt("id_rozvrh"), rs.getString("nazov"), rs.getString("popis"));
            this.aDatabaza.odpoj();
            return rozvrh;
        }
        catch (SQLException ex) {
            this.aDatabaza.odpoj();
            return null;
        }
    }

    public ArrayList<Hodina> nacitajHodiny(int paIDRozvrhu) {
        try {
            ArrayList<Hodina> zoznam = new ArrayList<Hodina>();
            String vyraz = "SELECT * FROM Hodina WHERE id_rozvrh=" + paIDRozvrhu + ";";
            ResultSet rs = this.aDatabaza.vykonaj(vyraz);
            while (rs.next()) {
                Hodina hodina = new Hodina(rs.getInt("den"), rs.getInt("cislo"), rs.getString("predmet"), rs.getString("miestnost"), rs.getString("ucitel"));
                zoznam.add(hodina);
            }
            this.aDatabaza.odpoj();
            return zoznam;
        }
        catch (SQLException ex) {
            this.aDatabaza.odpoj();
            return null;
        }
    }

    public void ulozHodiny(ArrayList<Hodina> paHodiny, int paIDRozvrhu) {
        for (Hodina hodina : paHodiny) {
            this.vytvorHodinu(paIDRozvrhu, hodina);
        }
    }

    public void aktualizujRozvrh(Rozvrh paRozvrh) {
        int id = paRozvrh.getIDRozvrhu();
        String nazov = this.osetriPrazdny(paRozvrh.getNazov());
        String popis = this.osetriPrazdny(paRozvrh.getPopis());
        String vyraz = "UPDATE Rozvrh SET nazov= '" + nazov + "'," + " popis='" + popis + "' WHERE id_rozvrh=" + id + ";";
        this.aDatabaza.vykonaj(vyraz);
        this.aDatabaza.odpoj();
    }

    public void vymazRozvrh(int paIDRozvrhu) {
        String vyraz = "DELETE FROM Hodina WHERE id_rozvrh=" + paIDRozvrhu + ";";
        this.aDatabaza.vykonaj(vyraz);
        this.aDatabaza.odpoj();
        vyraz = "DELETE FROM Rozvrh WHERE id_rozvrh=" + paIDRozvrhu + ";";
        this.aDatabaza.vykonaj(vyraz);
        this.aDatabaza.odpoj();
    }

    public void aktualizujHodinu(int paIDRozvrhu, Hodina paHodina) {
        int den = paHodina.getDen();
        int cislo = paHodina.getCisloHodiny();
        String predmet = this.osetriPrazdny(paHodina.getPredmet());
        String miestnost = this.osetriPrazdny(paHodina.getMiestnost());
        String ucitel = this.osetriPrazdny(paHodina.getUcitel());
        String vyraz = "UPDATE Hodina SET predmet= '" + predmet + "'," + " miestnost='" + miestnost + "', ucitel= '" + ucitel + "'" + " WHERE id_rozvrh=" + paIDRozvrhu + " AND den=" + den + "" + " AND cislo=" + cislo + ";";
        this.aDatabaza.vykonaj(vyraz);
        this.aDatabaza.odpoj();
    }

    private String osetriPrazdny(String paRetazec) {
        if (paRetazec == null) {
            return "";
        }
        return paRetazec;
    }
}

