/*
 * Decompiled with CFR 0.152.
 */
package tk.ufonet.rozvrhJava.gui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import tk.ufonet.rozvrhJava.jadro.Hodina;
import tk.ufonet.rozvrhJava.jadro.Ovladac;

public class ModelTabulkyRozvrhu
extends AbstractTableModel {
    private ArrayList<Hodina> aRozvrh;
    private Ovladac aOvladac;
    private int aPocetStlpcov;
    private int aPocetStlpcovZDat;

    public ModelTabulkyRozvrhu(Ovladac paOvladac) {
        this.aOvladac = paOvladac;
        this.aPocetStlpcov = 0;
        this.aPocetStlpcovZDat = 0;
    }

    public void zmenRozvrh(ArrayList<Hodina> paRozvrh) {
        this.aRozvrh = paRozvrh;
        if (this.aRozvrh != null) {
            this.aPocetStlpcov = this.aPocetStlpcovZDat = this.pocetStlpcovZDat(paRozvrh);
        }
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.aRozvrh == null) {
            return 0;
        }
        return 15;
    }

    @Override
    public int getColumnCount() {
        return this.aPocetStlpcov;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        return columnIndex + "";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int denVypocitany = rowIndex / 3;
        int riadokVypocitany = rowIndex % 3;
        if (columnIndex == 0 && riadokVypocitany == 1) {
            switch (denVypocitany) {
                case 0: {
                    return "PO";
                }
                case 1: {
                    return "UT";
                }
                case 2: {
                    return "STR";
                }
                case 3: {
                    return "\u0160T";
                }
                case 4: {
                    return "PIA";
                }
            }
            return "";
        }
        if (this.aRozvrh == null) {
            return null;
        }
        for (Hodina hodina : this.aRozvrh) {
            int cisloHodiny = hodina.getCisloHodiny();
            int cisloDna = hodina.getDen() - 1;
            if (cisloHodiny != columnIndex || cisloDna != denVypocitany) continue;
            switch (riadokVypocitany) {
                case 0: {
                    return hodina.getPredmet();
                }
                case 1: {
                    return hodina.getMiestnost();
                }
                case 2: {
                    return hodina.getUcitel();
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        int denVypocitany = rowIndex / 3;
        int riadokVypocitany = rowIndex % 3;
        int index = denVypocitany * 3;
        String predmet = (String)this.getValueAt(index, columnIndex);
        String miestnost = (String)this.getValueAt(index + 1, columnIndex);
        String ucitel = (String)this.getValueAt(index + 2, columnIndex);
        switch (riadokVypocitany) {
            case 0: {
                predmet = (String)value;
                break;
            }
            case 1: {
                miestnost = (String)value;
                break;
            }
            case 2: {
                ucitel = (String)value;
            }
        }
        this.aOvladac.pridajAktualizujHodinu(denVypocitany + 1, columnIndex, predmet, miestnost, ucitel);
        this.fireTableCellUpdated(rowIndex, columnIndex);
        this.aPocetStlpcovZDat = this.pocetStlpcovZDat(this.aRozvrh);
    }

    private int pocetStlpcovZDat(ArrayList<Hodina> paRozvrh) {
        int stlpce = 0;
        for (Hodina hodina : paRozvrh) {
            if (hodina.getCisloHodiny() <= stlpce) continue;
            stlpce = hodina.getCisloHodiny();
        }
        return stlpce + 1;
    }

    public void pridajStlpec() {
        ++this.aPocetStlpcov;
        this.fireTableStructureChanged();
    }

    public void odoberStlpec() {
        if (this.aPocetStlpcovZDat < this.aPocetStlpcov) {
            --this.aPocetStlpcov;
            this.fireTableStructureChanged();
        }
    }
}

