/*
 * Decompiled with CFR 0.152.
 */
package tk.ufonet.rozvrhJava.jadro;

import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JTable;
import tk.ufonet.rozvrhJava.databaza.SpravcaDatabazy;
import tk.ufonet.rozvrhJava.gui.ModelTabulkyRozvrhu;
import tk.ufonet.rozvrhJava.gui.Okno;
import tk.ufonet.rozvrhJava.gui.RendererTabulkyRozvrhu;
import tk.ufonet.rozvrhJava.jadro.Hodina;
import tk.ufonet.rozvrhJava.jadro.Rozvrh;
import tk.ufonet.rozvrhJava.jadro.TypRozvrhu;
import tk.ufonet.rozvrhJava.parser.IParser;
import tk.ufonet.rozvrhJava.parser.ParserUNIZA;
import tk.ufonet.rozvrhJava.parser.VyhladanyRozvrh;
import tk.ufonet.rozvrhJava.subory.NacitajXMLReturn;
import tk.ufonet.rozvrhJava.subory.VytvorExcel;
import tk.ufonet.rozvrhJava.subory.VytvorXML;

public class Ovladac {
    public static final String NAZOV_APP = "Rozvrh v1.1.0";
    public static final String VERZIA = "v1.1.0";
    public static final String VYUZITE_KNIZNICE = "jsoup - Java HTML Parser\n       (http://www.jsoup.org)\n\nSQLite JDBC Driver\n       (http://bitbucket.org/xerial/sqlite-jdbc)\n\nApache POI - the Java API for Microsoft Documents\n       (http://poi.apache.org)\n\n";
    public static final String LICENCIA = "    Program Rozvrh je \u0161\u00edren\u00fd ako FREEWARE,\nto znamen\u00e1, \u017ee ho pou\u017e\u00edvatelia m\u00f4\u017eu pou\u017e\u00edva\u0165 bezplatne.\nAutor nenesie \u017eiadnu zodpovednos\u0165 za ak\u00e9ko\u013evek \u0161kody\nsp\u00f4soben\u00e9 programom Rozvrh. \u00daprava programu,\nalebo jeho \u010dast\u00ed bez s\u00fahlasu autora je zak\u00e1zan\u00e1.";
    private SpravcaDatabazy aSpravcaDatabazy;
    private IParser aParserRozvrhu;
    private JFrame aHlavneOkno;
    private JTable aTabulka;
    private ModelTabulkyRozvrhu aModelTabulky;
    private ArrayList<Hodina> aRozvrh;
    private Rozvrh aRozvrhInfo;

    public Ovladac(Okno paHlavneOkno, JTable paTabulka) {
        this.aHlavneOkno = paHlavneOkno;
        this.aTabulka = paTabulka;
        this.aSpravcaDatabazy = new SpravcaDatabazy();
        this.aParserRozvrhu = new ParserUNIZA();
        this.aHlavneOkno.setTitle(NAZOV_APP);
        this.aTabulka.setVisible(false);
        this.aModelTabulky = new ModelTabulkyRozvrhu(this);
        this.aTabulka.setModel(this.aModelTabulky);
    }

    private void nacitajModelDoTabulky() {
        this.aModelTabulky.zmenRozvrh(this.aRozvrh);
        this.aTabulka.setDefaultRenderer(Object.class, new RendererTabulkyRozvrhu());
        this.aTabulka.setIntercellSpacing(new Dimension(0, 0));
        this.aTabulka.setVisible(true);
    }

    private void vymazModelZTabulky() {
        this.aModelTabulky.zmenRozvrh(null);
        this.aTabulka.setVisible(false);
    }

    public ArrayList<VyhladanyRozvrh> vyhladajRozvrh(TypRozvrhu paTyp, String paHladanyRet) {
        return this.aParserRozvrhu.vyhladajRozvrh(paTyp, paHladanyRet);
    }

    public void vytvorRozvrh(TypRozvrhu paTyp, String paHladanyRet, VyhladanyRozvrh paVybratyRozvrh, String paNazov, String paPopis) {
        this.aRozvrh = this.aParserRozvrhu.parsujRozvrh(paTyp, paHladanyRet, paVybratyRozvrh);
        this.vytvorRozvrh(paNazov, paPopis, this.aRozvrh);
    }

    private void vytvorRozvrh(String paNazov, String paPopis, ArrayList<Hodina> paRozvrh) {
        int id = this.aSpravcaDatabazy.vytvorRozvrh(paNazov, paPopis);
        this.aRozvrhInfo = new Rozvrh(id);
        this.setNazovRozvrhu(paNazov);
        this.aRozvrhInfo.setPopis(paPopis);
        this.aSpravcaDatabazy.ulozHodiny(paRozvrh, id);
        this.nacitajModelDoTabulky();
    }

    public void nacitajRozvrh(int paIDRozvrhu) {
        this.aRozvrh = this.aSpravcaDatabazy.nacitajHodiny(paIDRozvrhu);
        this.aRozvrhInfo = this.aSpravcaDatabazy.nacitajRozvrh(paIDRozvrhu);
        this.nacitajModelDoTabulky();
        this.aHlavneOkno.setTitle("Rozvrh v1.1.0 - " + this.getNazovRozvrhu());
    }

    public void vymazRozvrh(int paIDRozvrhu) {
        this.aSpravcaDatabazy.vymazRozvrh(paIDRozvrhu);
    }

    public void vymazAktualnyRozvrh() {
        if (this.aRozvrhInfo != null) {
            int id = this.aRozvrhInfo.getIDRozvrhu();
            this.vymazRozvrh(id);
            this.vymazModelZTabulky();
            this.aHlavneOkno.setTitle(NAZOV_APP);
        }
    }

    public String getNazovRozvrhu() {
        return this.aRozvrhInfo.getNazov();
    }

    public void setNazovRozvrhu(String paNazovRozvrhu) {
        this.aRozvrhInfo.setNazov(paNazovRozvrhu);
        this.aHlavneOkno.setTitle("Rozvrh v1.1.0 - " + paNazovRozvrhu);
        this.aSpravcaDatabazy.aktualizujRozvrh(this.aRozvrhInfo);
    }

    public String getPopisRozvrhu() {
        return this.aRozvrhInfo.getPopis();
    }

    public void setPopisRozvrhu(String paPopisRozvrhu) {
        this.aRozvrhInfo.setPopis(paPopisRozvrhu);
        this.aSpravcaDatabazy.aktualizujRozvrh(this.aRozvrhInfo);
    }

    public ArrayList<Rozvrh> dajZoznamRozvrhov() {
        return this.aSpravcaDatabazy.nacitajRozvrhy();
    }

    public void pridajAktualizujHodinu(int paDen, int paCisloHodiny, String paPredmet, String paMiestnost, String paUcitel) {
        for (Hodina hodina : this.aRozvrh) {
            if (hodina.getDen() != paDen || hodina.getCisloHodiny() != paCisloHodiny) continue;
            hodina.setPredmet(paPredmet);
            hodina.setMiestnost(paMiestnost);
            hodina.setUcitel(paUcitel);
            if (this.nullAleboPrazdny(paPredmet) && this.nullAleboPrazdny(paMiestnost) && this.nullAleboPrazdny(paUcitel)) {
                this.vymazHodinu(hodina);
            } else {
                this.aSpravcaDatabazy.aktualizujHodinu(this.aRozvrhInfo.getIDRozvrhu(), hodina);
            }
            return;
        }
        if (this.nullAleboPrazdny(paPredmet) && this.nullAleboPrazdny(paMiestnost) && this.nullAleboPrazdny(paUcitel)) {
            return;
        }
        Hodina novaHodina = new Hodina(paDen, paCisloHodiny, paPredmet, paMiestnost, paUcitel);
        this.aRozvrh.add(novaHodina);
        this.aSpravcaDatabazy.vytvorHodinu(this.aRozvrhInfo.getIDRozvrhu(), novaHodina);
    }

    public void pridajStlpecRozvrhu() {
        this.aModelTabulky.pridajStlpec();
    }

    public void odoberStlpecRozvrhu() {
        this.aModelTabulky.odoberStlpec();
    }

    public void exportujDoExcelu(File paSubor) {
        VytvorExcel vytvarac = new VytvorExcel(paSubor);
        vytvarac.vytvorSubor(this.aRozvrhInfo, this.aRozvrh);
    }

    private boolean nullAleboPrazdny(String paString) {
        return paString == null || paString.equals("");
    }

    public void vymazHodinu(Hodina paHodina) {
        int den = paHodina.getDen();
        int cislo = paHodina.getCisloHodiny();
        this.aSpravcaDatabazy.vymazHodinu(this.aRozvrhInfo.getIDRozvrhu(), den, cislo);
        this.aRozvrh.remove(paHodina);
    }

    public boolean jeNacitanyRozvrh() {
        return this.aRozvrh != null;
    }

    public void vymazanieVybratychBuniek() {
        int[] riadky = this.aTabulka.getSelectedRows();
        int[] stlpce = this.aTabulka.getSelectedColumns();
        for (int i : riadky) {
            for (int j : stlpce) {
                this.aModelTabulky.setValueAt(null, i, j);
            }
        }
    }

    public void vytvorXML(File paSubor) {
        VytvorXML.vytvorXML(paSubor, this.aRozvrhInfo, this.aRozvrh);
    }

    public void nacitajXML(File paSubor) {
        NacitajXMLReturn vystup = VytvorXML.nacitajXML(paSubor);
        if (vystup.getRozvrhInfo() != null) {
            this.vymazModelZTabulky();
            String nazov = vystup.getRozvrhInfo().getNazov();
            String popis = vystup.getRozvrhInfo().getPopis();
            this.vytvorRozvrh(nazov, popis, vystup.getRozvrh());
        }
    }
}

